var samplePageObj = {

  externalScript: ['../assets/ibsheet/plugins/ibsheet-excel.js'],
  // 샘플 타이틀
  title: 'Solid(커스텀행)',
  subtitle: '각 컬럼의 설정과 무관하게 동작하는 행을 추가하여 사용하실 수 있습니다.',
  // 샘플 설명
  desc: 'Solid 기능을 사용하시면 시트 상단 혹은 하단 영역에 고정된 형태의 별도 기능을 갖는 행을 추가하실 수 있습니다.'
        + '</br>InfoRow 행의 버튼을 클릭하여 다양한 기능을 적용 할 수 있습니다.'
        + '</br>버튼 위에 마우스를 올리면 해당 버튼에 대한 설명을 확인하실 수 있습니다.',

  // 객체 초기화 구문
  init: {

    Cfg: {
      SearchMode: 0,
      Export: {
        Url: (location.href.indexOf('localhost') > -1 ? '../jsp/' : 'https://api.ibleaders.com/ibsheet/v8/')
      },
      InfoRowConfig: {
        Visible: 1,
        Layout: [
          {
            Value: '<i name="icon" style="font-size:initial;" title="행 추가" class="fa-sharp fa-solid fa-plus"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" title="행 삭제" class="fa-sharp fa-solid fa-minus"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" title="Excel 다운" class="fa-sharp fa-solid fa-file-excel"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" title="CSV 다운" class="fa-sharp fa-solid fa-file-csv"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" title="Text 다운" class="fa-sharp fa-solid fa-file-lines"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" title="프린트" class="fa-sharp fa-solid fa-print"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" title="조회" class="fa-sharp fa-solid fa-database"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" title="저장" class="fa-sharp fa-solid fa-floppy-disk"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" id="showSource" title="소스탭 보이기" class="fa-sharp fa-solid fa-eye"></i>',
            Id: 'test',
            Type: 'Button',
            RelWidth: 0,
            Width: 18,
            OnClick: imageBtn
          },
          {
            Value: '<i name="icon" style="font-size:initial;" id="hideSource" title="소스탭 감추기" class="fa-sharp fa-solid fa-eye-slash"></i>',
            Type: 'Button',
            RelWidth: 0,
            Width: 19,
            OnClick: imageBtn
          },
          {
            Value: '<div><i name="icon" style="font-size:initial;" title="테마 변경" id="themeChangeBtn" class="fa-solid fa-palette"></i> &nbsp;:&nbsp;'
                      + '<select style=\'width:70px; border-radius:5px;\' id=\'changeThemes\' onChange=\'changeTheme();\'>'
                        + '<option value=\'0\'></option>'
                        + '<option value=\'1\'>Default</option>'
                        + '<option value=\'2\'>Grace</option>'
                        + '<option value=\'3\'>Material</option>'
                        + '<option value=\'4\'>Mint</option>'
                        + '<option value=\'5\'>Simple</option>'
                      + '</select>'
                    + '</div>',
            Align: 'Right',
            RelWidth: 0,
            MinWidth: 170,
            Width: 170,
          },
          {
            Value: '<div><i name="icon" style="font-size:initial;" title="언어 변경" class="fa-sharp fa-solid fa-globe" style=""></i> &nbsp;:&nbsp;'
                      + '<select style=\'width:60px; border-radius:5px;\' id=\'changeLang\' onChange=\'changeLang();\'>'
                      + '<option value=\'0\'></option>'
                      + '<option value=\'1\'>한국어</option>'
                      + '<option value=\'2\'>영어</option>'
                      + '<option value=\'3\'>일본어</option>'
                      + '<option value=\'4\'>중국어</option>'
                      + '</select></div>',
            Align: 'Left',
            RelWidth: 0,
            MinWidth: 130,
            Width: 130,
          },
          'Count'
        ],
        Space: 'Top'
      }
    },
    Cols: [
      {
        Header: '선택',
        Type: 'Bool',
        Name: 'chk',
        Width: '60'
      },
      {
        Header: '영화명',
        Type: 'Text',
        Name: 'title',
        MinWidth: '250',
        RelWidth: 1
      },
      {
        Header: '감독',
        Type: 'Text',
        Name: 'director',
        Width: '120'
      },
      {
        Header: '제작사',
        Type: 'Text',
        Name: 'company',
        MinWidth: '180',
        RelWidth: 1
      },
      {
        Header: '개봉일',
        Type: 'Date',
        Name: 'openDate',
        Width: '120',
        Format: 'yyyy/MM/dd',
        EditFormat: 'yyyy/MM/dd'
      },
      {
        Header: '영화유형',
        Type: 'Enum',
        Name: 'movieType',
        Width: '100',
        Enum: '|SF|가족|드라마|액션|범죄|스릴러|판타지|애니메이션|다큐멘터리|기타',
        EnumKeys: '|AA|BB|CC|DD|EE|FF|GG|HH|II|JJ'
      },
      {
        Header: '국적',
        Type: 'Text',
        Name: 'country',
        Width: '80'
      },
      {
        Header: '스크린수',
        Type: 'Int',
        Name: 'screenNo',
        Width: '80',
        Format: '#,###',
        FormulaRow: 'Sum'
      },
      {
        Header: '전국매출액',
        Type: 'Int',
        Name: 'amt',
        Width: '150',
        Format: '#,###',
        FormulaRow: 'Sum'
      },
      {
        Header: '전국관객수',
        Type: 'Int',
        Name: 'people',
        Width: '100',
        Format: '#,###',
        FormulaRow: 'Sum'
      },
      {
        Header: '등급',
        Type: 'Enum',
        Name: 'rate',
        Width: '80',
        Enum: '|전체|12세|15세|청불',
        EnumKeys: '|01|02|03|04|05'
      },

    ],

    Solid: [
      {
        Def: 'MySolid',
        id: 'solidRow',
        Space: '1',
        Cells: 'Title,MyCell1,Spacer1,MyCell2,Spacer2,MyCell3,EmptyCell',
        Title: {
          Type: 'Text',
          Value: '변경할 행을 선택해주세요.',
          Width: 180,
          CanFocus: 0
        },
        Expression: {
          MinWidth: '200'
        },
        Spacer1: { // 중간 공백 셀 정의
          Type: 'Text',
          Width: 3,
          CanFocus: 0
        },
        Spacer2: { // 중간 공백 셀 정의
          Type: 'Text',
          Width: 3,
          CanFocus: 0
        },
        MyCell1: { // 두번째 커스텀 셀의 기능 설정
          Type: 'Enum',
          Enum: '|영화명|제작사|개봉일|영화유형|국적|등급',
          EnumKeys: '|title|company|openDate|movieType|country|rate',
          Width: 150
        },
        MyCell2: { // 두번째 커스텀 셀의 기능 설정
          Type: 'Text',
          Width: 220,
          EmptyValue: '변경할 값'
        },
        MyCell3: { // 세번째 커스텀 셀의 기능 설정
          Type: 'Button',
          Button: 'Button',
          Value: '변경하기',
          OnClick: myCellClick
        },
        EmptyCell: {
          CanFocus: 0,
          RelWidth: 1
        }
      }
    ],
    Def: {
      MySolid: {
        OnChange: changeSolid, // Solid 내의 값이 변경될때 발생하는 이벤트 정의
        Color: '#E5E4D1', // 배경색 설정
      }
    }
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func:
   '<div><lable>솔리드행 위치 변경</lable>'
  + '<hr/>'
  + '<input type=\'radio\' name=\'chk\' onclick=\'sampleBtn(this,-1)\'><label>시트 밖 위</label>'
  + '<input type=\'radio\' name=\'chk\' onclick=\'sampleBtn(this,0)\'><label>헤더 위</label>'
  + '<input type=\'radio\' name=\'chk\' onclick=\'sampleBtn(this,1)\' checked><label>헤더 아래</label>'
  + '<hr/>'

  + '<input type=\'radio\' name=\'chk\' onclick=\'sampleBtn(this,2)\'><label>합계 위 </label>'
  + '<input type=\'radio\' name=\'chk\' onclick=\'sampleBtn(this,3)\'><label>합계 아래</label>'
  + '<input type=\'radio\' name=\'chk\' onclick=\'sampleBtn(this,5)\'><label>시트 밖 아래</label></div>'
  + '<input type=\'hidden\' id=\'showSourceTab\' value=\'1\' />'
  + '<input type=\'hidden\' id=\'themeValue\' value=\'1\' />'
  + '<input type=\'hidden\' id=\'langValue\' value=\'1\' />',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%;display:flex;\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
    if (arguments[0].type === 'radio') { // 솔리드 위치 선택
      sheet.getRowById('solidRow').Space = arguments[1]; // 솔리드행 위치 변경
      sheet.rerender();
    }
  },
  // jsfiddle 용
  externalFunction: {
    changeTheme: function () {
      var changeTheme = parseInt(document.querySelector('#changeThemes').value, 10);
      var prefixTheme = '';
      var urlTheme = '';

      switch (changeTheme) {
        case 1:
          prefixTheme = 'IB';
          urlTheme = '/default/main.css';
          break;
        case 2:
          prefixTheme = 'IBGR';
          urlTheme = '/grace/main.css';
          break;
        case 3:
          prefixTheme = 'IBMR';
          urlTheme = '/material/main.css';
          break;
        case 4:
          prefixTheme = 'IBMT';
          urlTheme = '/mint/main.css';
          break;
        case 5:
          prefixTheme = 'IBSP';
          urlTheme = '/simple/main.css';
          break;
        default:
          prefixTheme = 'IB';
          urlTheme = '/default/main.css';
      }
      if (changeTheme === 0) {
        document.getElementById('themeValue').value = 1;
      } else {
        document.getElementById('themeValue').value = changeTheme;
      }

      urlTheme = '../assets/ibsheet/css' + urlTheme;
      sheet.setTheme(prefixTheme, urlTheme, 1);
    },
    changeLang: function () {
      var changeLang = parseInt(document.querySelector('#changeLang').value, 10);
      var code;
      var path = '../assets/ibsheet/locale/';

      switch (changeLang) {
        case 1:
          code = 'Ko';
          sheet.Header.chk = '선택';
          sheet.Header.title = '영화명';
          sheet.Header.director = '감독';
          sheet.Header.company = '제작사';
          sheet.Header.openDate = '개봉일';
          sheet.Header.movieType = '영화유형';
          sheet.Header.country = '국적';
          sheet.Header.screenNo = '스크린수';
          sheet.Header.people = '전국관객수';
          sheet.Header.amt = '전국매출액';
          sheet.Header.rate = '등급';
          break;
        case 2:
          code = 'En';
          sheet.Header.chk = 'check';
          sheet.Header.title = 'title';
          sheet.Header.director = 'director';
          sheet.Header.company = 'company';
          sheet.Header.chk = 'Check';
          sheet.Header.title = 'Title';
          sheet.Header.director = 'Director';
          sheet.Header.company = 'Company';
          sheet.Header.openDate = 'Opening date';
          sheet.Header.movieType = 'Movie type';
          sheet.Header.country = 'Nationality';
          sheet.Header.screenNo = 'Number of screens';
          sheet.Header.people = 'National audience';
          sheet.Header.amt = 'Nationwide sales';
          sheet.Header.rate = 'Rating';
          break;
        case 3:
          code = 'Jp';
          sheet.Header.chk = '選択';
          sheet.Header.title = '映画名';
          sheet.Header.director = '監督';
          sheet.Header.company = 'メーカー';
          sheet.Header.openDate = '開封日';
          sheet.Header.movieType = '映画の種類';
          sheet.Header.country = '国籍';
          sheet.Header.screenNo = 'スクリーン数';
          sheet.Header.people = '全国観客数';
          sheet.Header.amt = '全国売上高';
          sheet.Header.rate = '評価';
          break;
        case 4:
          code = 'Cn';
          sheet.Header.chk = '选择';
          sheet.Header.title = '电影名称';
          sheet.Header.director = '导向器';
          sheet.Header.company = '制片人';
          sheet.Header.openDate = '开业日期';
          sheet.Header.movieType = '电影类型';
          sheet.Header.country = '国籍';
          sheet.Header.screenNo = '屏幕数量';
          sheet.Header.people = '全国观众';
          sheet.Header.amt = '全国销售';
          sheet.Header.rate = '评分';
          break;
        default:
          code = 'Ko';
          sheet.Header.chk = '선택';
          sheet.Header.title = '영화명';
          sheet.Header.director = '감독';
          sheet.Header.company = '제작사';
          sheet.Header.openDate = '개봉일';
          sheet.Header.movieType = '영화유형';
          sheet.Header.country = '국적';
          sheet.Header.screenNo = '스크린수';
          sheet.Header.people = '전국관객수';
          sheet.Header.amt = '전국매출액';
          sheet.Header.rate = '등급';
      }
      sheet.setLocale(code, true, path, true);
      if (changeLang === 0) {
        document.getElementById('langValue').value = 1;
      } else {
        document.getElementById('langValue').value = changeLang;
      }
    }
  },

  // event구문
  event: {
    onRenderFinish: function (evtParam) {
      var themeVal = document.getElementById('themeValue').value;
      var langVal = document.getElementById('langValue').value;

      document.getElementById('changeThemes').value = themeVal;
      document.getElementById('changeLang').value = langVal;
    },
    onAfterSave: function (evtParam) {
      var themeVal = document.getElementById('themeValue').value;
      var langVal = document.getElementById('langValue').value;

      document.getElementById('changeThemes').value = themeVal;
      document.getElementById('changeLang').value = langVal;
    },
    onResize: function (evtParam) {
      var themeVal = document.getElementById('themeValue').value;
      var langVal = document.getElementById('langValue').value;

      setTimeout(function () {
        document.getElementById('changeThemes').value = themeVal;
        document.getElementById('changeLang').value = langVal;
      }, 150);
    }
  },
  // data
  data: [
    {
      title: '보헤미안랩소디',
      director: '브라이언싱어',
      company: '이십세기폭스코리아(주)',
      openDate: '2018-10-31',
      movieType: 'CC',
      country: '미국',
      screenNo: '936',
      amt: '32956999856',
      people: '3797929',
      rate: '02'
    },
    {
      title: '아쿠아맨',
      director: '제임스완',
      company: '워너브러더스코리아(주)',
      openDate: '2018-12-19',
      movieType: 'DD',
      country: '미국',
      screenNo: '1285',
      amt: '30454537381',
      people: '3491880',
      rate: '02'
    },
    {
      title: '국가부도의날',
      director: '최국희',
      company: '씨제이이앤엠(주)',
      openDate: '2018-11-28',
      movieType: 'CC',
      country: '한국',
      screenNo: '1180',
      amt: '25411008467',
      people: '3003339',
      rate: '02'
    },
    {
      title: '마약왕',
      director: '우민호',
      company: '(주)쇼박스',
      openDate: '2018-12-19',
      movieType: 'EE',
      country: '한국',
      screenNo: '1297',
      amt: '15784846552',
      people: '1813607',
      rate: '04'
    },
    {
      title: '도어락',
      director: '이권',
      company: '메가박스중앙(주)플러스엠',
      openDate: '2018-12-05',
      movieType: 'FF',
      country: '한국',
      screenNo: '954',
      amt: '12683552886',
      people: '1543800',
      rate: '03'
    },
    {
      title: '스윙키즈',
      director: '강형철',
      company: '(주)넥스트엔터테인먼트월드(NEW)',
      openDate: '2018-12-19',
      movieType: 'CC',
      country: '한국',
      screenNo: '984',
      amt: '10304683502',
      people: '1258324',
      rate: '02'
    },
    {
      title: 'PMC:더벙커',
      director: '김병우',
      company: '씨제이이앤엠(주)',
      openDate: '2018-12-26',
      movieType: 'DD',
      country: '한국',
      screenNo: '1081',
      amt: '9704311367',
      people: '1179037',
      rate: '03'
    },
    {
      title: '범블비',
      director: '트래비스나이트',
      company: '롯데컬처웍스(주)롯데엔터테인먼트',
      openDate: '2018-12-25',
      movieType: 'DD',
      country: '미국',
      screenNo: '1016',
      amt: '9756092752',
      people: '1167151',
      rate: '02'
    },
    {
      title: '스파이더맨:뉴유니버스',
      director: '밥퍼시케티,피터램지,로드니로스맨',
      company: '소니픽쳐스엔터테인먼트코리아주식회사극장배급지점',
      openDate: '2018-12-12',
      movieType: 'HH',
      country: '미국',
      screenNo: '722',
      amt: '5305289076',
      people: '639934',
      rate: '02'
    },
    {
      title: '호두까기인형과4개의왕국',
      director: '라세할스트롬,조존스톤',
      company: '월트디즈니컴퍼니코리아유한책임회사',
      openDate: '2018-12-06',
      movieType: 'GG',
      country: '미국',
      screenNo: '294',
      amt: '4120500900',
      people: '513809',
      rate: '01'
    },
    {
      title: '그린치',
      director: '스콧모시어',
      company: '유니버설픽쳐스인터내셔널코리아(유)',
      openDate: '2018-12-19',
      movieType: 'HH',
      country: '미국',
      screenNo: '724',
      amt: '3675388950',
      people: '485058',
      rate: '01'
    },
    {
      title: '점박이한반도의공룡2:새로운낙원',
      director: '한상호',
      company: '(주)넥스트엔터테인먼트월드(NEW)',
      openDate: '2018-12-25',
      movieType: 'HH',
      country: '한국',
      screenNo: '672',
      amt: '2941571400',
      people: '375315',
      rate: '01'
    },
    {
      title: '성난황소',
      director: '김민호',
      company: '(주)쇼박스',
      openDate: '2018-11-22',
      movieType: 'EE',
      country: '한국',
      screenNo: '1010',
      amt: '2558924225',
      people: '311026',
      rate: '03'
    },
    {
      title: '극장판짱구는못말려:아뵤!쿵후보이즈~라면대란~',
      director: '타카하시와타루',
      company: '씨제이이앤엠(주)',
      openDate: '2018-12-19',
      movieType: 'HH',
      country: '일본',
      screenNo: '489',
      amt: '2148708050',
      people: '277206',
      rate: '01'
    },
    {
      title: '모털엔진',
      director: '크리스찬리버스',
      company: '유니버설픽쳐스인터내셔널코리아(유)',
      openDate: '2018-12-05',
      movieType: 'DD',
      country: '미국',
      screenNo: '661',
      amt: '2324362119',
      people: '267896',
      rate: '02'
    },
    {
      title: '완벽한타인',
      director: '이재규',
      company: '롯데컬처웍스(주)롯데엔터테인먼트',
      openDate: '2018-10-31',
      movieType: 'CC',
      country: '한국',
      screenNo: '1313',
      amt: '1964919100',
      people: '237333',
      rate: '03'
    },
    {
      title: '런닝맨:풀룰루의역습',
      director: '윤준상',
      company: '(주)넥스트엔터테인먼트월드(NEW)',
      openDate: '2018-12-05',
      movieType: 'HH',
      country: '한국',
      screenNo: '511',
      amt: '1413729750',
      people: '186191',
      rate: '01'
    },
    {
      title: '극장판포켓몬스터모두의이야기',
      director: '야지마테츠오',
      company: '(주)이수C&E',
      openDate: '2018-12-19',
      movieType: 'HH',
      country: '일본',
      screenNo: '493',
      amt: '1314100400',
      people: '169677',
      rate: '01'
    },
    {
      title: '후드',
      director: '오토바서스트',
      company: '(주)이수C&E',
      openDate: '2018-11-28',
      movieType: 'JJ',
      country: '미국',
      screenNo: '628',
      amt: '1303467875',
      people: '157836',
      rate: '02'
    },
    {
      title: '신비한동물들과그린델왈드의EE',
      director: '데이빗예이츠',
      company: '워너브러더스코리아(주)',
      openDate: '2018-11-14',
      movieType: 'GG',
      country: '미국',
      screenNo: '1601',
      amt: '998206166',
      people: '119099',
      rate: '02'
    },
    {
      title: '부탁하나만들어줘',
      director: '폴페이그',
      company: '(주)팝엔터테인먼트',
      openDate: '2018-12-12',
      movieType: 'FF',
      country: '미국',
      screenNo: '461',
      amt: '988418788',
      people: '114536',
      rate: '04'
    },
    {
      title: '엘리엇과산타썰매단',
      director: '제니퍼웨스트콧',
      company: '(주)팝엔터테인먼트',
      openDate: '2018-12-12',
      movieType: 'HH',
      country: '캐나다',
      screenNo: '335',
      amt: '399032800',
      people: '57579',
      rate: '01'
    },
    {
      title: '헌터킬러',
      director: '도노반마시',
      company: '씨네그루(주)키다리이엔티',
      openDate: '2018-12-06',
      movieType: 'DD',
      country: '미국',
      screenNo: '226',
      amt: '459532450',
      people: '55921',
      rate: '03'
    },
    {
      title: '번개맨의비밀',
      director: '강유선',
      company: '(주)디스테이션',
      openDate: '2018-12-06',
      movieType: 'BB',
      country: '한국',
      screenNo: '309',
      amt: '382525050',
      people: '49574',
      rate: '01'
    },
    {
      title: '바울',
      director: '앤드류하얏트',
      company: '(재)CBS',
      openDate: '2018-10-31',
      movieType: 'CC',
      country: '미국',
      screenNo: '227',
      amt: '367725850',
      people: '47916',
      rate: '03'
    },
    {
      title: '인생후르츠',
      director: '켄시후시하라',
      company: '(주)엣나인필름',
      openDate: '2018-12-06',
      movieType: 'II',
      country: '일본',
      screenNo: '33',
      amt: '255306350',
      people: '33311',
      rate: '01'
    },
    {
      title: '베일리어게인',
      director: '라세할스트롬',
      company: '(주)홈초이스',
      openDate: '2018-11-22',
      movieType: 'JJ',
      country: '미국',
      screenNo: '189',
      amt: '234262900',
      people: '27840',
      rate: '01'
    },
    {
      title: '모어댄블루',
      director: '임효겸',
      company: '오드',
      openDate: '2018-12-12',
      movieType: 'JJ',
      country: '대만',
      screenNo: '132',
      amt: '210275600',
      people: '25935',
      rate: '02'
    },
    {
      title: '투프렌즈',
      director: '빅터아즈에프',
      company: '(주)박수엔터테인먼트',
      openDate: '2018-11-29',
      movieType: 'HH',
      country: '러시아',
      screenNo: '273',
      amt: '174120850',
      people: '24324',
      rate: '01'
    },
    {
      title: '로마',
      director: '알폰소쿠아론',
      company: '판씨네마(주)',
      openDate: '2018-12-12',
      movieType: 'CC',
      country: '멕시코',
      screenNo: '32',
      amt: '173245000',
      people: '21401',
      rate: '03'
    },
    {
      title: '러빙빈센트:비하인드에디션',
      director: '도로타코비엘라,휴웰치맨',
      company: '(주)이수C&E',
      openDate: '2018-12-13',
      movieType: 'HH',
      country: '영국',
      screenNo: '97',
      amt: '171441500',
      people: '19886',
      rate: '03'
    },
    {
      title: '트와이스랜드',
      director: '',
      company: '씨제이씨지브이(CJCGV)(주)',
      openDate: '2018-12-07',
      movieType: 'II',
      country: '한국',
      screenNo: '53',
      amt: '153785000',
      people: '18254',
      rate: '01'
    },
    {
      title: '거미줄에걸린소녀',
      director: '페드알바레즈',
      company: '소니픽쳐스엔터테인먼트코리아주식회사극장배급지점',
      openDate: '2018-11-28',
      movieType: 'DD',
      country: '미국',
      screenNo: '313',
      amt: '142155150',
      people: '17328',
      rate: '03'
    },
    {
      title: '갈매기',
      director: '마이클메이어',
      company: '(주)뮤제엔터테인먼트',
      openDate: '2018-12-13',
      movieType: 'CC',
      country: '미국',
      screenNo: '43',
      amt: '88614250',
      people: '10719',
      rate: '02'
    },
    {
      title: '토마스와친구들:우정의대모험',
      director: '데이비드스토튼',
      company: '와이드릴리즈(주)',
      openDate: '2018-12-13',
      movieType: 'HH',
      country: '영국',
      screenNo: '196',
      amt: '71627750',
      people: '9899',
      rate: '01'
    },
    {
      title: '영주',
      director: '차성덕',
      company: 'CGV아트하우스',
      openDate: '2018-11-22',
      movieType: 'CC',
      country: '한국',
      screenNo: '106',
      amt: '72196800',
      people: '9342',
      rate: '02'
    },
    {
      title: '메리셸리:프랑켄슈타인의탄생',
      director: '하이파알-만수르',
      company: '(주)팝엔터테인먼트',
      openDate: '2018-12-20',
      movieType: 'CC',
      country: '미국',
      screenNo: '37',
      amt: '76730950',
      people: '9208',
      rate: '03'
    },
    {
      title: '미스터스마일',
      director: '데이빗로워리',
      company: '(주)티캐스트',
      openDate: '2018-12-27',
      movieType: 'CC',
      country: '미국',
      screenNo: '56',
      amt: '78284800',
      people: '9138',
      rate: '03'
    },
    {
      title: '극장판파워레인저갤럭시포스VS스페이스스쿼드',
      director: '사카모토코이치',
      company: '(주)이수C&E',
      openDate: '2018-12-06',
      movieType: 'HH',
      country: '일본',
      screenNo: '199',
      amt: '64418550',
      people: '8375',
      rate: '01'
    },
    {
      title: '이차크의행복한바이올린',
      director: '앨리슨쉐르닉',
      company: '(주)영화사진진',
      openDate: '2018-12-20',
      movieType: 'II',
      country: '미국',
      screenNo: '26',
      amt: '61702350',
      people: '8050',
      rate: '01'
    },
    {
      title: '콜드플레이:헤드풀오브드림스',
      director: '매트화이트크로스',
      company: '에스디시코리아주식회사',
      openDate: '2018-12-28',
      movieType: 'II',
      country: '영국',
      screenNo: '23',
      amt: '112304000',
      people: '8017',
      rate: '02'
    },
    {
      title: '일곱개의대죄:천공의포로',
      director: '아베노리유키',
      company: '(주)엠제이픽쳐스',
      openDate: '2018-11-29',
      movieType: 'HH',
      country: '일본',
      screenNo: '88',
      amt: '58542200',
      people: '7301',
      rate: '03'
    },
    {
      title: '번더스테이지:더무비',
      director: '박준수',
      company: '월트디즈니컴퍼니코리아유한책임회사',
      openDate: '2018-11-15',
      movieType: 'JJ',
      country: '한국',
      screenNo: '243',
      amt: '61452400',
      people: '7200',
      rate: '01'
    },
    {
      title: '인디아일',
      director: '토마스스터버',
      company: 'M&M인터내셔널',
      openDate: '2018-11-22',
      movieType: 'CC',
      country: '독일',
      screenNo: '11',
      amt: '60723400',
      people: '7100',
      rate: '03'
    },
    {
      title: '더파티',
      director: '샐리포터',
      company: '(주)라이크콘텐츠',
      openDate: '2018-12-20',
      movieType: 'JJ',
      country: '영국',
      screenNo: '32',
      amt: '54265350',
      people: '6494',
      rate: '03'
    },
    {
      title: '툴리',
      director: '제이슨라이트맨',
      company: '(주)리틀빅픽쳐스',
      openDate: '2018-11-22',
      movieType: 'CC',
      country: '캐나다',
      screenNo: '161',
      amt: '45814200',
      people: '6304',
      rate: '03'
    },
    {
      title: '출국',
      director: '노규엽',
      company: '',
      openDate: '2018-11-14',
      movieType: 'CC',
      country: '한국',
      screenNo: '274',
      amt: '34234100',
      people: '4854',
      rate: '03'
    },
    {
      title: '스타이즈본',
      director: '브래들리쿠퍼',
      company: '워너브러더스코리아(주)',
      openDate: '2018-10-09',
      movieType: 'CC',
      country: '미국',
      screenNo: '555',
      amt: '38276600',
      people: '4367',
      rate: '03'
    },
    {
      title: '폴란드로간아이들',
      director: '추상미',
      company: '커넥트픽쳐스(주)',
      openDate: '2018-10-31',
      movieType: 'II',
      country: '한국',
      screenNo: '181',
      amt: '33082500',
      people: '4344',
      rate: '01'
    },
    {
      title: '어른이되면',
      director: '장혜영',
      company: '(주)시네마달',
      openDate: '2018-12-13',
      movieType: 'II',
      country: '한국',
      screenNo: '24',
      amt: '28217900',
      people: '3811',
      rate: '01'
    },
    {
      title: '은혼2:규칙은깨라고있는것',
      director: '후쿠다유이치',
      company: '메가박스중앙(주)플러스엠',
      openDate: '2018-12-13',
      movieType: 'JJ',
      country: '일본',
      screenNo: '48',
      amt: '30828650',
      people: '3698',
      rate: '02'
    },
    {
      title: '데스티네이션웨딩',
      director: '빅터레빈',
      company: '(주)유로커뮤니케이션',
      openDate: '2018-12-13',
      movieType: 'JJ',
      country: '미국',
      screenNo: '85',
      amt: '28856500',
      people: '3612',
      rate: '03'
    },
    {
      title: '하나빼고완벽한뉴욕아파트',
      director: '소피브룩스',
      company: '판씨네마(주)',
      openDate: '2018-12-27',
      movieType: 'JJ',
      country: '미국',
      screenNo: '37',
      amt: '30944800',
      people: '3609',
      rate: '02'
    },
    {
      title: '리벤져',
      director: '이승원',
      company: '(주)리틀빅픽쳐스',
      openDate: '2018-12-06',
      movieType: 'DD',
      country: '한국',
      screenNo: '57',
      amt: '22088100',
      people: '3028',
      rate: '03'
    },
    {
      title: '삼국-무영자',
      director: '장예모',
      company: '(주)제이앤씨미디어그룹',
      openDate: '2018-12-13',
      movieType: 'DD',
      country: '중국',
      screenNo: '38',
      amt: '15498500',
      people: '2914',
      rate: '03'
    },
    {
      title: '꼬마비행기피티와친구들:사막구출대작전',
      director: '루카스퀴아오',
      company: '와이드릴리즈(주)',
      openDate: '2018-11-22',
      movieType: 'HH',
      country: '중국',
      screenNo: '212',
      amt: '13130650',
      people: '2367',
      rate: '01'
    },
    {
      title: '저니스엔드',
      director: '사울딥',
      company: '(주)스톰픽쳐스코리아',
      openDate: '2018-11-28',
      movieType: '전쟁',
      country: '영국',
      screenNo: '63',
      amt: '18399950',
      people: '2323',
      rate: '03'
    },
    {
      title: '해피투게더',
      director: '김정환',
      company: '플레이리스트(주)',
      openDate: '2018-11-15',
      movieType: 'CC',
      country: '한국',
      screenNo: '240',
      amt: '13762000',
      people: '2268',
      rate: '02'
    },
    {
      title: '별나라몰리몬스터',
      director: '마티아스브런,테드시저',
      company: '(주)영화사빅',
      openDate: '2018-11-29',
      movieType: 'HH',
      country: '독일',
      screenNo: '63',
      amt: '16035200',
      people: '2144',
      rate: '01'
    },
    {
      title: '헬페스트',
      director: '그레고리플로킨',
      company: '(주)삼백상회',
      openDate: '2018-12-13',
      movieType: 'JJ',
      country: '미국',
      screenNo: '82',
      amt: '16378800',
      people: '2047',
      rate: '03'
    },
    {
      title: '캡틴샤키',
      director: '허버트베일란드',
      company: '예지림엔터테인먼트',
      openDate: '2018-11-22',
      movieType: 'HH',
      country: '독일',
      screenNo: '175',
      amt: '11332400',
      people: '1981',
      rate: '01'
    },
    {
      title: '산상수훈',
      director: '유영의',
      company: '이언픽쳐스,(주)그란',
      openDate: '2017-12-07',
      movieType: 'CC',
      country: '한국',
      screenNo: '71',
      amt: '14204650',
      people: '1862',
      rate: '01'
    },
    {
      title: '위시업',
      director: '스콧스피어',
      company: '(주)영화사그램',
      openDate: '2018-12-13',
      movieType: 'JJ',
      country: '미국',
      screenNo: '61',
      amt: '14607550',
      people: '1828',
      rate: '03'
    },
    {
      title: '샘',
      director: '황규일',
      company: '롯데컬처웍스(주)롯데엔터테인먼트',
      openDate: '2018-11-29',
      movieType: 'JJ',
      country: '한국',
      screenNo: '68',
      amt: '13392500',
      people: '1589',
      rate: '02'
    },
    {
      title: '신데렐라',
      director: '',
      company: '(주)인스터피씨엠',
      openDate: '2018-12-01',
      movieType: 'JJ',
      country: '미국',
      screenNo: '11',
      amt: '35695000',
      people: '1544',
      rate: '01'
    },
    {
      title: '리틀이태리',
      director: '도날드페트리',
      company: '(주)드림팩트엔터테인먼트',
      openDate: '2018-12-06',
      movieType: 'JJ',
      country: '캐나다',
      screenNo: '11',
      amt: '11483800',
      people: '1530',
      rate: '03'
    },
    {
      title: '동네사람들',
      director: '임진순',
      company: '(주)리틀빅픽쳐스',
      openDate: '2018-11-07',
      movieType: 'DD',
      country: '한국',
      screenNo: '731',
      amt: '10755500',
      people: '1493',
      rate: '03'
    },
    {
      title: '안녕,나의소녀시절이여',
      director: '김한석',
      company: '(주)드림팩트엔터테인먼트',
      openDate: '2018-12-12',
      movieType: 'II',
      country: '한국',
      screenNo: '11',
      amt: '11325500',
      people: '1446',
      rate: '01'
    },
    {
      title: '새벽의약속',
      director: '에릭바르비에',
      company: '(주)일레븐엔터테인먼트',
      openDate: '2018-11-22',
      movieType: 'CC',
      country: '프랑스',
      screenNo: '21',
      amt: '8805450',
      people: '1244',
      rate: '03'
    },
    {
      title: '안개속소녀',
      director: '도나토카리시',
      company: '(주)미디어마그나',
      openDate: '2018-12-06',
      movieType: '미스터리',
      country: '이탈리아',
      screenNo: '31',
      amt: '9631900',
      people: '1216',
      rate: '02'
    },
    {
      title: '너의췌장을먹고싶어',
      director: '우시지마신이치로',
      company: '(주)넥스트엔터테인먼트월드(NEW)',
      openDate: '2018-11-15',
      movieType: 'HH',
      country: '일본',
      screenNo: '319',
      amt: '8575900',
      people: '1070',
      rate: '02'
    },
    {
      title: '선종무문관',
      director: '윤용진',
      company: '(주)드림팩트엔터테인먼트',
      openDate: '2018-12-13',
      movieType: 'CC',
      country: '한국',
      screenNo: '3',
      amt: '8529800',
      people: '1009',
      rate: '01'
    },
    {
      title: '군산:거위를노래하다',
      director: '장률',
      company: '(주)트리플픽쳐스',
      openDate: '2018-11-08',
      movieType: 'CC',
      country: '한국',
      screenNo: '92',
      amt: '5923800',
      people: '1005',
      rate: '03'
    },
    {
      title: '다이빙:그녀에빠지다',
      director: '멜라니로랑',
      company: '(주)디스테이션',
      openDate: '2018-11-29',
      movieType: 'JJ',
      country: '프랑스',
      screenNo: '12',
      amt: '6728150',
      people: '963',
      rate: '03'
    },
    {
      title: '1991봄',
      director: '권경원',
      company: '(주)인디플러그',
      openDate: '2018-10-31',
      movieType: 'II',
      country: '한국',
      screenNo: '26',
      amt: '6958000',
      people: '937',
      rate: '02'
    },
    {
      title: '리스펙트',
      director: '심재희',
      company: '커넥트픽쳐스(주)',
      openDate: '2018-11-28',
      movieType: 'II',
      country: '한국',
      screenNo: '41',
      amt: '8581500',
      people: '935',
      rate: '03'
    },
    {
      title: '뷰티풀데이즈',
      director: '윤재호',
      company: '(주)콘텐츠판다,(주)스마일이엔티',
      openDate: '2018-11-21',
      movieType: 'CC',
      country: '한국',
      screenNo: '142',
      amt: '6360700',
      people: '922',
      rate: '02'
    },
    {
      title: '부다페스트로큰롤',
      director: '게르게이포뇨',
      company: '알토미디어(주)',
      openDate: '2018-12-20',
      movieType: 'JJ',
      country: '헝가리',
      screenNo: '7',
      amt: '6592400',
      people: '891',
      rate: '03'
    },
    {
      title: '신과함께-인과연',
      director: '김용화,김용화',
      company: '롯데컬처웍스(주)롯데엔터테인먼트',
      openDate: '2018-08-01',
      movieType: 'GG',
      country: '한국',
      screenNo: '2235',
      amt: '6283000',
      people: '837',
      rate: '02'
    },
    {
      title: '어느BB',
      director: '고레에다히로카즈',
      company: '(주)티캐스트',
      openDate: '2018-07-26',
      movieType: 'CC',
      country: '일본',
      screenNo: '126',
      amt: '6592000',
      people: '811',
      rate: '03'
    },
    {
      title: '카메라를멈추면안돼!',
      director: '우에다신이치로',
      company: '(주)디오시네마,(주)영화사그램',
      openDate: '2018-08-23',
      movieType: 'JJ',
      country: '일본',
      screenNo: '57',
      amt: '6321766',
      people: '804',
      rate: '03'
    },
    {
      title: '화씨11/9:트럼프의시대',
      director: '마이클무어',
      company: '(주)누리픽쳐스,(주)영화사진진',
      openDate: '2018-11-22',
      movieType: 'II',
      country: '미국',
      screenNo: '73',
      amt: '5673150',
      people: '773',
      rate: '03'
    },
    {
      title: '나츠메우인장:세상과연을맺다',
      director: '오오모리타카히로,이토히데키',
      company: '(주)애니플러스',
      openDate: '2018-10-31',
      movieType: 'HH',
      country: '일본',
      screenNo: '110',
      amt: '7106200',
      people: '758',
      rate: '01'
    },
    {
      title: '허스토리',
      director: '민규동,민규동',
      company: '(주)넥스트엔터테인먼트월드(NEW)',
      openDate: '2018-06-27',
      movieType: 'CC',
      country: '한국',
      screenNo: '696',
      amt: '3544000',
      people: '722',
      rate: '02'
    },
    {
      title: '토스카',
      director: '미햐엘슈투르밍어',
      company: '(주)케빈앤컴퍼니',
      openDate: '2018-11-18',
      movieType: 'JJ',
      country: '독일',
      screenNo: '11',
      amt: '17364000',
      people: '711',
      rate: '02'
    },
    {
      title: '소녀의세계',
      director: '안정민',
      company: '(주)드림팩트엔터테인먼트',
      openDate: '2018-11-29',
      movieType: 'JJ',
      country: '한국',
      screenNo: '14',
      amt: '3730900',
      people: '700',
      rate: '02'
    },
    {
      title: '박물관이진짜살아있다',
      director: '마틴코틱,이나예블라니코바',
      company: '(주)팝엔터테인먼트',
      openDate: '2018-11-08',
      movieType: 'HH',
      country: '체코',
      screenNo: '252',
      amt: '3785000',
      people: '699',
      rate: '01'
    },
    {
      title: '구스범스:몬스터의역습',
      director: '아리산델',
      company: '소니픽쳐스엔터테인먼트코리아주식회사극장배급지점',
      openDate: '2018-11-07',
      movieType: 'GG',
      country: '미국',
      screenNo: '167',
      amt: '3476000',
      people: '695',
      rate: '02'
    },
    {
      title: '할로윈',
      director: '데이빗고든그린',
      company: '유니버설픽쳐스인터내셔널코리아(유)',
      openDate: '2018-10-31',
      movieType: 'JJ',
      country: '미국',
      screenNo: '536',
      amt: '3300000',
      people: '660',
      rate: '04'
    },
    {
      title: '다영씨',
      director: '고봉수',
      company: '㈜인디스토리',
      openDate: '2018-12-06',
      movieType: 'CC',
      country: '한국',
      screenNo: '19',
      amt: '4562100',
      people: '640',
      rate: '02'
    },
    {
      title: '로빈슨의언더워터JJ',
      director: '막심볼코브',
      company: '(주)박수엔터테인먼트',
      openDate: '2018-11-15',
      movieType: 'HH',
      country: '러시아',
      screenNo: '216',
      amt: '2976000',
      people: '522',
      rate: '01'
    },
    {
      title: '버블패밀리',
      director: '마민지',
      company: '무브먼트',
      openDate: '2018-12-20',
      movieType: 'II',
      country: '한국',
      screenNo: '12',
      amt: '3575200',
      people: '498',
      rate: '01'
    },
    {
      title: '해피댄싱',
      director: '리차드론크레인',
      company: '주식회사씨네룩스',
      openDate: '2018-11-15',
      movieType: 'CC',
      country: '영국',
      screenNo: '25',
      amt: '3177100',
      people: '464',
      rate: '02'
    },
    {
      title: '타샤튜더',
      director: '마츠타니미츠에',
      company: '(주)마노엔터테인먼트',
      openDate: '2018-09-13',
      movieType: 'II',
      country: '일본',
      screenNo: '28',
      amt: '2972000',
      people: '450',
      rate: '01'
    },
    {
      title: '친구엄마2018',
      director: '이진명',
      company: '(주)소나무픽쳐스',
      openDate: '2018-12-04',
      movieType: 'JJ',
      country: '한국',
      screenNo: '21',
      amt: '2573000',
      people: '436',
      rate: '04'
    },
    {
      title: '죄많은소녀',
      director: '김의석',
      company: 'CGV아트하우스',
      openDate: '2018-09-13',
      movieType: 'CC',
      country: '한국',
      screenNo: '70',
      amt: '3222000',
      people: '403',
      rate: '03'
    },
    {
      title: '마담B',
      director: '윤재호',
      company: '영화배급협동조합씨네소파',
      openDate: '2018-11-15',
      movieType: 'II',
      country: '한국',
      screenNo: '19',
      amt: '2394500',
      people: '367',
      rate: '02'
    },
    {
      title: '미쓰백',
      director: '이지원',
      company: '(주)리틀빅픽쳐스',
      openDate: '2018-10-11',
      movieType: 'CC',
      country: '한국',
      screenNo: '638',
      amt: '2939000',
      people: '344',
      rate: '03'
    },
    {
      title: '출동!소방관샘:외계인대소동',
      director: '개리앤드류스',
      company: '(주)머스트씨무비릴리징컴퍼니',
      openDate: '2018-11-08',
      movieType: 'HH',
      country: '영국',
      screenNo: '152',
      amt: '2101000',
      people: '328',
      rate: '01'
    },
    {
      title: '택시5',
      director: '프랑크가스탐비드',
      company: '(주)삼백상회',
      openDate: '2018-11-22',
      movieType: 'DD',
      country: '프랑스',
      screenNo: '224',
      amt: '2099400',
      people: '321',
      rate: '03'
    },
    {
      title: '인어전설',
      director: '오멸',
      company: '(주)미로스페이스',
      openDate: '2018-11-15',
      movieType: 'JJ',
      country: '한국',
      screenNo: '14',
      amt: '1985000',
      people: '278',
      rate: '02'
    },
    {
      title: '다잉',
      director: '페르난도프랑코',
      company: '(주)더블앤조이픽쳐스',
      openDate: '2018-12-27',
      movieType: 'CC',
      country: '스페인',
      screenNo: '6',
      amt: '1255200',
      people: '277',
      rate: '02'
    },
    {
      title: '국가성생활관리위원회-무삭제판',
      director: '지산겸',
      company: '(주)케이알씨지',
      openDate: '2018-12-13',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '1183000',
      people: '244',
      rate: '04'
    },
    {
      title: '세번째엄마무삭제판',
      director: '민이',
      company: '(주)케이알씨지',
      openDate: '2018-12-11',
      movieType: 'JJ',
      country: '한국',
      screenNo: '18',
      amt: '1183000',
      people: '244',
      rate: '04'
    },
    {
      title: '미친도시',
      director: '장태령',
      company: '영화사마그나',
      openDate: '2018-08-30',
      movieType: 'CC',
      country: '한국',
      screenNo: '4',
      amt: '1906000',
      people: '243',
      rate: '03'
    },
    {
      title: '천당의밤과안개',
      director: '정성일',
      company: '주식회사마운틴픽쳐스',
      openDate: '2018-11-29',
      movieType: 'II',
      country: '한국',
      screenNo: '5',
      amt: '2561200',
      people: '242',
      rate: '01'
    },
    {
      title: '집의시간들',
      director: '라야',
      company: 'KT&G상상마당영화사업팀컴퍼니에스에스(주)',
      openDate: '2018-10-25',
      movieType: 'II',
      country: '한국',
      screenNo: '20',
      amt: '1964200',
      people: '230',
      rate: '01'
    },
    {
      title: '사돈처녀',
      director: '김태수',
      company: '(주)컨텐츠빌리지',
      openDate: '2018-12-14',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '1046000',
      people: '223',
      rate: '04'
    },
    {
      title: '릴라와마법의책',
      director: '마르셀라링콘곤잘레스',
      company: '(주)영화사오원',
      openDate: '2018-11-08',
      movieType: 'JJ',
      country: '콜롬비아',
      screenNo: '24',
      amt: '1228000',
      people: '211',
      rate: '01'
    },
    {
      title: '아메리카타운',
      director: '전수일',
      company: '전국예술영화관협회',
      openDate: '2018-12-06',
      movieType: 'CC',
      country: '한국',
      screenNo: '7',
      amt: '1197000',
      people: '203',
      rate: '03'
    },
    {
      title: '28세미성년',
      director: '장모',
      company: '(주)드림팩트엔터테인먼트',
      openDate: '2018-11-21',
      movieType: 'JJ',
      country: '중국',
      screenNo: '135',
      amt: '1575500',
      people: '203',
      rate: '03'
    },
    {
      title: '봄이가도',
      director: '장준엽,진청하,전신환',
      company: '(주)시네마달',
      openDate: '2018-09-13',
      movieType: 'CC',
      country: '한국',
      screenNo: '31',
      amt: '1200000',
      people: '200',
      rate: '02'
    },
    {
      title: '창궐',
      director: '김성훈',
      company: '(주)넥스트엔터테인먼트월드(NEW)',
      openDate: '2018-10-25',
      movieType: '사극',
      country: '한국',
      screenNo: '1351',
      amt: '1568000',
      people: '197',
      rate: '03'
    },
    {
      title: '초대녀2',
      director: '최우성',
      company: '(주)컨텐츠빌리지',
      openDate: '2018-12-28',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '1424000',
      people: '196',
      rate: '04'
    },
    {
      title: '안시성',
      director: '김광식',
      company: '(주)넥스트엔터테인먼트월드(NEW)',
      openDate: '2018-09-19',
      movieType: '사극',
      country: '한국',
      screenNo: '1540',
      amt: '933000',
      people: '185',
      rate: '02'
    },
    {
      title: '원더풀고스트',
      director: '조원희',
      company: '(주)제이앤씨미디어그룹,TCO(주)더콘텐츠온',
      openDate: '2018-09-26',
      movieType: 'JJ',
      country: '한국',
      screenNo: '351',
      amt: '1288000',
      people: '184',
      rate: '02'
    },
    {
      title: '퍼스트맨',
      director: '데이미언셔젤',
      company: '유니버설픽쳐스인터내셔널코리아(유)',
      openDate: '2018-10-18',
      movieType: 'AA',
      country: '미국',
      screenNo: '1190',
      amt: '1594000',
      people: '183',
      rate: '02'
    },
    {
      title: '여선생2',
      director: '김대성',
      company: '(주)영화사히트',
      openDate: '2018-12-18',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '946000',
      people: '173',
      rate: '04'
    },
    {
      title: '남의아내',
      director: '한동호',
      company: '(주)가온콘텐츠',
      openDate: '2018-12-18',
      movieType: 'CC',
      country: '한국',
      screenNo: '20',
      amt: '942000',
      people: '171',
      rate: '04'
    },
    {
      title: '가정부길들이기',
      director: '한동호',
      company: '(주)가온콘텐츠',
      openDate: '2018-12-26',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '938000',
      people: '169',
      rate: '04'
    },
    {
      title: '에스코바르',
      director: '페르난도레온데아라노아',
      company: '(주)영화사빅',
      openDate: '2018-11-15',
      movieType: 'EE',
      country: '스페인',
      screenNo: '99',
      amt: '680000',
      people: '164',
      rate: '03'
    },
    {
      title: '풀잎들',
      director: '홍상수',
      company: '(주)콘텐츠판다,(주)영화제작전원사,무브먼트',
      openDate: '2018-10-25',
      movieType: 'CC',
      country: '한국',
      screenNo: '54',
      amt: '1244400',
      people: '162',
      rate: '03'
    },
    {
      title: '알래스카북극곰',
      director: '윤중부',
      company: '(주)나우콘텐츠',
      openDate: '2018-12-13',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '848000',
      people: '161',
      rate: '04'
    },
    {
      title: '곰돌이푸다시만나행복해',
      director: '마크포스터',
      company: '월트디즈니컴퍼니코리아유한책임회사',
      openDate: '2018-10-03',
      movieType: 'JJ',
      country: '미국',
      screenNo: '536',
      amt: '1192000',
      people: '149',
      rate: '01'
    },
    {
      title: '극장판헬로카봇:백악기시대',
      director: '최신규',
      company: '(주)넥스트엔터테인먼트월드(NEW)',
      openDate: '2018-08-01',
      movieType: 'HH',
      country: '한국',
      screenNo: '758',
      amt: '828600',
      people: '137',
      rate: '01'
    },
    {
      title: '밤치기',
      director: '정가영',
      company: '무브먼트',
      openDate: '2018-11-01',
      movieType: 'JJ',
      country: '한국',
      screenNo: '27',
      amt: '1126000',
      people: '132',
      rate: '03'
    },
    {
      title: '극장판뽀잉:슈퍼변신의비밀',
      director: '정미화',
      company: '(주)이수C&E,(주)시너지미디어',
      openDate: '2018-09-20',
      movieType: 'HH',
      country: '한국',
      screenNo: '294',
      amt: '836000',
      people: '129',
      rate: '01'
    },
    {
      title: '크레이지리치아시안',
      director: '존추',
      company: '워너브러더스코리아(주)',
      openDate: '2018-10-25',
      movieType: 'JJ',
      country: '미국',
      screenNo: '531',
      amt: '871000',
      people: '128',
      rate: '02'
    },
    {
      title: '뉴욕라이브러리에서',
      director: '프레데릭와이즈만',
      company: '(주)영화사진진',
      openDate: '2018-10-11',
      movieType: 'II',
      country: '미국',
      screenNo: '17',
      amt: '1333000',
      people: '125',
      rate: '01'
    },
    {
      title: '자매의교환섹스',
      director: '장두만',
      company: '에이원미디어',
      openDate: '2018-12-04',
      movieType: 'JJ',
      country: '한국',
      screenNo: '1',
      amt: '668000',
      people: '122',
      rate: '04'
    },
    {
      title: '하나식당',
      director: '최낙희',
      company: '(주)영화사오원',
      openDate: '2018-11-22',
      movieType: 'CC',
      country: '한국',
      screenNo: '40',
      amt: '832000',
      people: '121',
      rate: '02'
    },
    {
      title: '윌리',
      director: '칼멘데스',
      company: '㈜코리아스크린',
      openDate: '2018-10-25',
      movieType: 'HH',
      country: '말레이시아',
      screenNo: '162',
      amt: '680000',
      people: '120',
      rate: '01'
    },
    {
      title: '맛있는누나들',
      director: '강백호',
      company: '스마일컨텐츠',
      openDate: '2018-12-19',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '644000',
      people: '110',
      rate: '04'
    },
    {
      title: '나부야나부야',
      director: '최정우',
      company: '㈜인디스토리',
      openDate: '2018-09-20',
      movieType: 'II',
      country: '한국',
      screenNo: '18',
      amt: '216000',
      people: '108',
      rate: '01'
    },
    {
      title: '프리다의그해여름',
      director: '카를라시몬',
      company: '(주)디스테이션',
      openDate: '2018-10-25',
      movieType: 'CC',
      country: '스페인',
      screenNo: '37',
      amt: '886000',
      people: '107',
      rate: '01'
    },
    {
      title: '바르다가사랑한얼굴들',
      director: '아녜스바르다,제이알',
      company: '(주)영화사진진',
      openDate: '2018-06-14',
      movieType: 'II',
      country: '프랑스',
      screenNo: '53',
      amt: '673000',
      people: '93',
      rate: '01'
    },
    {
      title: '호밀밭의반항아',
      director: '대니스트롱',
      company: '(주)트리플픽쳐스',
      openDate: '2018-10-18',
      movieType: 'CC',
      country: '미국',
      screenNo: '68',
      amt: '749000',
      people: '86',
      rate: '02'
    },
    {
      title: '친애하는우리아이',
      director: '미시마유키코',
      company: '아이엠',
      openDate: '2018-11-01',
      movieType: 'CC',
      country: '일본',
      screenNo: '24',
      amt: '380000',
      people: '77',
      rate: '03'
    },
    {
      title: '늦여름',
      director: '조성규',
      company: '하준사',
      openDate: '2018-10-25',
      movieType: 'JJ',
      country: '한국',
      screenNo: '9',
      amt: '664000',
      people: '73',
      rate: '03'
    },
    {
      title: '내여자친구의엄마',
      director: '김부곤',
      company: '(주)영화사가을',
      openDate: '2018-12-04',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '518000',
      people: '71',
      rate: '04'
    },
    {
      title: '그녀와아줌마의동거',
      director: '유강',
      company: '(주)나우콘텐츠',
      openDate: '2018-12-07',
      movieType: '',
      country: '한국',
      screenNo: '1',
      amt: '300000',
      people: '60',
      rate: '04'
    },
    {
      title: '춘천,춘천',
      director: '장우진',
      company: '무브먼트',
      openDate: '2018-09-26',
      movieType: 'CC',
      country: '한국',
      screenNo: '4',
      amt: '351000',
      people: '44',
      rate: '03'
    },
    {
      title: '필름스타인리버풀',
      director: '폴맥기건',
      company: '그린나래미디어(주)',
      openDate: '2018-10-25',
      movieType: 'CC',
      country: '영국',
      screenNo: '35',
      amt: '362000',
      people: '44',
      rate: '03'
    },
    {
      title: '여곡성',
      director: '유영선',
      company: '(주)스마일이엔티',
      openDate: '2018-11-08',
      movieType: 'JJ',
      country: '한국',
      screenNo: '212',
      amt: '261600',
      people: '43',
      rate: '03'
    },
    {
      title: '언더더트리',
      director: '하프슈타인군나르지그라쏜',
      company: '이언픽쳐스',
      openDate: '2018-11-08',
      movieType: 'JJ',
      country: '아이슬란드',
      screenNo: '19',
      amt: '372600',
      people: '41',
      rate: '04'
    },
    {
      title: '데스트랩',
      director: '오인천',
      company: '블리트필름',
      openDate: '2018-12-06',
      movieType: 'FF',
      country: '한국',
      screenNo: '1',
      amt: '223500',
      people: '35',
      rate: '03'
    },
    {
      title: '건양강호:운뢰검법의비밀',
      director: '장뢰',
      company: '레이크엔터테인먼트',
      openDate: '2018-12-13',
      movieType: 'DD',
      country: '중국',
      screenNo: '5',
      amt: '34000',
      people: '34',
      rate: '03'
    },
    {
      title: '벽속에숨은마법시계',
      director: '일라이로스',
      company: 'CGV아트하우스',
      openDate: '2018-10-31',
      movieType: 'GG',
      country: '미국',
      screenNo: '609',
      amt: '140000',
      people: '28',
      rate: '01'
    },
    {
      title: '류이치사카모토:코다',
      director: '스티븐쉬블',
      company: '주식회사씨네룩스',
      openDate: '2018-06-14',
      movieType: 'II',
      country: '일본',
      screenNo: '49',
      amt: '179000',
      people: '25',
      rate: '01'
    },
    {
      title: '철의심장을가진남자',
      director: '세드릭히메네즈',
      company: '아이엠',
      openDate: '2018-11-08',
      movieType: 'DD',
      country: '미국',
      screenNo: '51',
      amt: '212200',
      people: '25',
      rate: '03'
    },
    {
      title: '미스터앤미스터대디',
      director: '앤드류플레밍',
      company: '(주)라이크콘텐츠',
      openDate: '2018-11-22',
      movieType: 'JJ',
      country: '미국',
      screenNo: '11',
      amt: '219000',
      people: '24',
      rate: '03'
    },
    {
      title: '두번째겨울',
      director: '김의곤',
      company: '(주)미로스페이스',
      openDate: '2018-12-27',
      movieType: 'CC',
      country: '한국',
      screenNo: '3',
      amt: '132800',
      people: '23',
      rate: '02'
    },
    {
      title: '바이킹데스티니',
      director: '데이비드L.G.휴즈',
      company: '주식회사풍경소리',
      openDate: '2018-12-20',
      movieType: 'DD',
      country: '영국',
      screenNo: '5',
      amt: '32000',
      people: '21',
      rate: '03'
    },
    {
      title: '스페이스치킨:마법부적의비밀',
      director: '알렉스오렐,에두와르도슐츠',
      company: '(주)박수엔터테인먼트',
      openDate: '2018-10-25',
      movieType: 'HH',
      country: '미국',
      screenNo: '273',
      amt: '138500',
      people: '21',
      rate: '01'
    },
    {
      title: '밀애:착한형수',
      director: '김부곤',
      company: '(주)영화사가을',
      openDate: '2018-12-27',
      movieType: 'JJ',
      country: '한국',
      screenNo: '20',
      amt: '105000',
      people: '20',
      rate: '04'
    },
    {
      title: '걷기좋은날',
      director: '박용주',
      company: '(주)웃기씨네',
      openDate: '2018-10-12',
      movieType: 'CC',
      country: '한국',
      screenNo: '1',
      amt: '38500',
      people: '12',
      rate: '02'
    },
    {
      title: '나미야잡화점의기적:또하나의이야기',
      director: '한지에',
      company: '윤스',
      openDate: '2018-11-08',
      movieType: 'GG',
      country: '중국',
      screenNo: '47',
      amt: '74000',
      people: '10',
      rate: '02'
    },
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};

function changeSolid(evtParam) {
  var eSheet = evtParam.sheet;
  var eRow = evtParam.row;
  var eCol = evtParam.col;

  if (eCol === 'MyCell1') { // 변경할 항목 선택시
    var eValue = eSheet.getValue(eRow, eCol);

    if (eValue === 'openDate') { eRow.MyCell2Type = 'Date'; } else if (eValue === 'movieType') {
      eRow.MyCell2Type = 'Enum';
      eRow.MyCell2Enum = '|SF|가족|드라마|액션|범죄|스릴러|판타지|애니메이션|다큐멘터리|기타';
      eRow.MyCell2EnumKeys = '|AA|BB|CC|DD|EE|FF|GG|HH|II|JJ';
    } else if (eValue === 'rate') {
      eRow.MyCell2Type = 'Enum';
      eRow.MyCell2Enum = '|전체|12세|15세|청불';
      eRow.MyCell2EnumKeys = '|01|02|03|04';
    } else {
      eRow.MyCell2Type = 'Text';
    }
    eRow.MyCell2 = '';
    eSheet.refreshRow(eRow);
  }
}

function imageBtn(evtParam) {
  var ImageBtn = evtParam.col;
  var tabBtn = document.getElementById('tabBtn');
  var tabContents = document.getElementById('tabContents');
  var mytabConts = document.getElementById('myTabs_contents-0');
  var mytabContsFirst = document.getElementById('myTabs_contents-1');
  var mytabContsSecond = document.getElementById('myTabs_contents-2');
  var mytabContsThird = document.getElementById('myTabs_contents-3');
  var mytabContsFourth = document.getElementById('myTabs_contents-4');
  var mytabContsFifth = document.getElementById('myTabs_contents-5');
  var fRow = sheet.getFocusedRow();
  var delChk = sheet.getRowsByChecked('chk');
  var selRows = sheet.getSelectedRows();
  var delChkLen = delChk.length;
  var selRowsLen = selRows.length;
  var ShowArea = document.getElementById('showSource');
  var hideArea = document.getElementById('hideSource');

  switch (ImageBtn) {
    case 'CustomCells1': sheet.addRow(); break;
    case 'CustomCells2':
      if (fRow.Added) { // 행이 추가되었을 때
        sheet.removeRow(fRow);
        break;
      } else {
        if (delChkLen !== 0) { // 체크박스 선택 삭제
          for (var i = 0; i < delChkLen; i++) {
            sheet.deleteRow(delChk[i]);
          }
        }
        if (selRowsLen !== 0) { // 셀 선택 삭제
          for (var i = 0; i < selRowsLen; i++) {
            sheet.deleteRow(selRows[i]);
          }
        } else {
          sheet.deleteRow(fRow);
        }
        break;
      }
    case 'CustomCells3':
      sheet.down2Excel({
        SheetDesign: 1,
        merge: 1,
        fileName: 'mySheet.xlsx'
      });
      break;
    case 'CustomCells4':
      sheet.down2Text({
        colDelim: ',',
        fileName: 'mySheet.csv'
      });
      break;
    case 'CustomCells5':
      sheet.down2Text({
        fileName: 'mySheet.txt'
      });
      break;
    case 'CustomCells6':
      sheet.doPrint();
      break;
    case 'CustomCells7':
      var data = sheet.getSaveJson(0).data;

      sheet.loadSearchData(data);
      break;
    case 'CustomCells8':
      var url = '/samples/customer/save_success.jsp';

      if (location.href.indexOf('localhost') > -1) {
        url = '../jsp' + url;
      } else {
        url = 'https://api.ibleaders.com/ibsheet/v8' + url;
      }
      sheet.doSave(url, 'EMPNO=9812321&EMPNM=CHRIS');
      break;
    case 'CustomCells9':
      if (location.href.indexOf('fiddle') === -1) {
        tabBtn.style.visibility = '';
        tabContents.style.visibility = '';
        mytabConts.style.visibility = '';
        mytabContsFirst.style.visibility = '';
        mytabContsSecond.style.visibility = '';
        mytabContsThird.style.visibility = '';
        mytabContsFourth.style.visibility = '';
        mytabContsFifth.style.visibility = '';
      } else {
        alert('해당 기능은 jsfiddle 에서 사용할 수 없습니다.');
      }
      break;
    case 'CustomCells10':
      if (location.href.indexOf('fiddle') === -1) {
        tabBtn.style.visibility = 'hidden';
        tabContents.style.visibility = 'hidden';
        mytabConts.style.visibility = 'hidden';
        mytabContsFirst.style.visibility = 'hidden';
        mytabContsSecond.style.visibility = 'hidden';
        mytabContsThird.style.visibility = 'hidden';
        mytabContsFourth.style.visibility = 'hidden';
        mytabContsFifth.style.visibility = 'hidden';
      } else {
        alert('해당 기능은 jsfiddle 에서 사용할 수 없습니다.');
      }
      break;
    default:
  }
}

function myCellClick(evtParam) {
  evtParam.sheet.endEdit(1);
  if (evtParam.sheet.getRowsByChecked('chk').length === 0) {
    alert('변경하려는 행을 체크하세요.');
  } else if (evtParam.row.MyCell1 === undefined || evtParam.row.MyCell2 == undefined) {
    alert('변경할 컬럼을 선택 후 값을 입력해주세요.');
  } else {
    var sRow = evtParam.sheet.getRowsByChecked('chk');
    var sCol = evtParam.row.MyCell1;
    var sVal = evtParam.row.MyCell2;

    for (var i = 0; i < sRow.length; i++) {
      evtParam.sheet.setString(evtParam.sheet.getRowsByChecked('chk')[i], sCol, sVal, 1);
    }
  }
}

function changeTheme() {
  var changeTheme = parseInt(document.querySelector('#changeThemes').value, 10);
  var prefixTheme = '';
  var urlTheme = '';

  switch (changeTheme) {
    case 1:
      prefixTheme = 'IB';
      urlTheme = '/default/main.css';
      break;
    case 2:
      prefixTheme = 'IBGR';
      urlTheme = '/grace/main.css';
      break;
    case 3:
      prefixTheme = 'IBMR';
      urlTheme = '/material/main.css';
      break;
    case 4:
      prefixTheme = 'IBMT';
      urlTheme = '/mint/main.css';
      break;
    case 5:
      prefixTheme = 'IBSP';
      urlTheme = '/simple/main.css';
      break;
    default:
      prefixTheme = 'IB';
      urlTheme = '/default/main.css';
  }
  urlTheme = '../assets/ibsheet/css' + urlTheme;
  sheet.setTheme(prefixTheme, urlTheme, 1);

  if (changeTheme === 0) {
    document.getElementById('themeValue').value = 1;
    $('#changeThemes').val(1).prop('selected', true);
  } else {
    document.getElementById('themeValue').value = changeTheme;
  }
}

function changeLang() {
  var changeLang = parseInt(document.querySelector('#changeLang').value, 10);
  var code;
  var path = '../assets/ibsheet/locale/';

  switch (changeLang) {
    case 1:
      code = 'Ko';
      sheet.Header.chk = '선택';
      sheet.Header.title = '영화명';
      sheet.Header.director = '감독';
      sheet.Header.company = '제작사';
      sheet.Header.openDate = '개봉일';
      sheet.Header.movieType = '영화유형';
      sheet.Header.country = '국적';
      sheet.Header.screenNo = '스크린수';
      sheet.Header.people = '전국관객수';
      sheet.Header.amt = '전국매출액';
      sheet.Header.rate = '등급';
      break;
    case 2:
      code = 'En';
      sheet.Header.chk = 'check';
      sheet.Header.title = 'title';
      sheet.Header.director = 'director';
      sheet.Header.company = 'company';
      sheet.Header.chk = 'Check';
      sheet.Header.title = 'Title';
      sheet.Header.director = 'Director';
      sheet.Header.company = 'Company';
      sheet.Header.openDate = 'Opening date';
      sheet.Header.movieType = 'Movie type';
      sheet.Header.country = 'Nationality';
      sheet.Header.screenNo = 'Number of screens';
      sheet.Header.people = 'National audience';
      sheet.Header.amt = 'Nationwide sales';
      sheet.Header.rate = 'Rating';
      break;
    case 3:
      code = 'Jp';
      sheet.Header.chk = '選択';
      sheet.Header.title = '映画名';
      sheet.Header.director = '監督';
      sheet.Header.company = 'メーカー';
      sheet.Header.openDate = '開封日';
      sheet.Header.movieType = '映画の種類';
      sheet.Header.country = '国籍';
      sheet.Header.screenNo = 'スクリーン数';
      sheet.Header.people = '全国観客数';
      sheet.Header.amt = '全国売上高';
      sheet.Header.rate = '評価';
      break;
    case 4:
      code = 'Cn';
      sheet.Header.chk = '选择';
      sheet.Header.title = '电影名称';
      sheet.Header.director = '导向器';
      sheet.Header.company = '制片人';
      sheet.Header.openDate = '开业日期';
      sheet.Header.movieType = '电影类型';
      sheet.Header.country = '国籍';
      sheet.Header.screenNo = '屏幕数量';
      sheet.Header.people = '全国观众';
      sheet.Header.amt = '全国销售';
      sheet.Header.rate = '评分';
      break;
    default:
      code = 'Ko';
      sheet.Header.chk = '선택';
      sheet.Header.title = '영화명';
      sheet.Header.director = '감독';
      sheet.Header.company = '제작사';
      sheet.Header.openDate = '개봉일';
      sheet.Header.movieType = '영화유형';
      sheet.Header.country = '국적';
      sheet.Header.screenNo = '스크린수';
      sheet.Header.people = '전국관객수';
      sheet.Header.amt = '전국매출액';
      sheet.Header.rate = '등급';
  }
  sheet.setLocale({
    code,
    load: true,
    path,
    render: true
  });
  if (changeLang === 0) {
    document.getElementById('langValue').value = 1;
  } else {
    document.getElementById('langValue').value = changeLang;
  }
}
